<?
set_time_limit(1800);

$CLS='backup';
class backup
{
	function init() {
		global $X;
		$X->NAVI[] = $X->ADMIN->module_name();

		$this->EXCLUDE=array('/backup', '/cache');

		if($_POST['action']=='backup') return $this->create_backup();
		if($_POST['action']=='restore') return $this->restore_backup();


		$sql=$X->DB->q(' SHOW TABLE STATUS ');
		while($dane=$X->DB->fa($sql)) {
			$db_size+=$dane['Data_length']+$dane['Index_length'];
			$rows+=$dane['Rows'];
			$table_count++;
		}
		if($db_size>=1024*1024) {
			$db_size=round($db_size/(1024*1024), 1).' MB';
		} else {
			$db_size=round($db_size/1024, 1).' KB';
		}


		if(is_dir(ROOT_PATH.'/backup/')) {
			$b_dirs=@opendir(ROOT_PATH.'/backup/');
			while(false!==($b_dir=@readdir($b_dirs))) {
				if($b_dir!='.' && $b_dir!='..') $backups[] = $b_dir;
			}
			@rsort($backups);
		}


		if(count($backups)>0) {
			foreach($backups as $backup) {
				$base=ROOT.'/backup/'.$backup;
				$base2=ROOT_PATH.'/backup/'.$backup;
				$backups_rows.='
					<tr>
						<td class="center">'.str_replace(array('_','.'),array(' ',':'),$backup).'</td>
						<td class="center">'.(file_exists($base2.'/ftp.tar.gz') ? '<span class="ico b_down"></span>&nbsp;&nbsp;<a href="'.$base.'/ftp.tar.gz"><b>'.round(filesize($base2.'/ftp.tar.gz')/(1024*1024), 2).' MB</b>' : '<span class="ico b_no"></span>').'</a></td>
						<td class="center">'.(file_exists($base2.'/sql.tar.gz') ? '<span class="ico b_down"></span>&nbsp;&nbsp;<a href="'.$base.'/sql.tar.gz"><b>'.round(filesize($base2.'/sql.tar.gz')/(1024*1024), 2).' MB</b>' : '<span class="ico b_no"></span>').'</a></td>
						<td class="center">'.$X->FORM->checkbox('del[]',$backup).'</td>
						<td class="center">'.$X->FORM->radio('restore', $backup, '').'</td>
					</tr>
				';
			}
			$backups_rows.='<tr><td colspan="10" class="right">'.$X->FORM->submit_link_potwierdzenie('Wykonaj zaznaczone operacje').'</td></tr>';
		} else {
			$backups_rows.=$X->ADMIN->empty_table();
		}


		$html='
			<br />
			<div class="fleft">
				'.$X->ADMIN->inline_table(array(
					'head' => '<th colspan="10">Rozmiar systemu</th>',
					'body' => '
						<tr>
							<td width="70">FTP</td>
							<td><b id="ftp_size"><img src="images/loading.gif" alt="" class="fleft" /></b></td>
							<td width="110" class="right"><b id="ftp_files"><img src="images/loading.gif" alt="" class="fright" /></b></td>
							<td width="110" class="right"><b id="ftp_dirs"><img src="images/loading.gif" alt="" class="fright" /></b></td>
						</tr>
						<tr>
							<td>MySQL</td>
							<td><b>'.$db_size.'</b></td>
							<td class="right"><b>'.$rows.' rekordów</b></td>
							<td class="right"><b>'.$table_count.' tabel</b></td>
						</tr>
					',
					'width' => 400
				)).'
				<br /><br />
				<script type="text/javascript">
					function calc_size(manual) {
						if(manual==true) {
							$("#ftp_size").html(\'<img src="images/loading.gif" alt="" class="fleft" />\');
							$("#ftp_files").html(\'<img src="images/loading.gif" alt="" class="fright" />\');
							$("#ftp_dirs").html(\'<img src="images/loading.gif" alt="" class="fright" />\');
						}

						$.ajax({
							url: "includes/ajax/check_resource.php?SID='.SID.'&type=dir",
							data: "type=dir&dir='.base64_encode(ROOT_PATH).'&exclude='.base64_encode(@serialize($this->EXCLUDE)).'&exclude_textarea="+$("#skip_dirs").val(),
							type: "post",
							cache: false,
							success: function(response) {
								$("#ftp_size").html(response.nice_size);
								$("#ftp_files").html(response.files+" plików");
								$("#ftp_dirs").html(response.dirs+" katalogów");
							}
						});
					}
					$(document).ready(calc_size);
				</script>


				<form action="" method="post">
					'.$X->ADMIN->inline_table(array(
						'head' => '<th colspan="10">Wykonaj nową kopię</th>',
						'body' => '
							<tr>
								<td width="75" class="right">FTP&nbsp;</td>
								<td >'.$X->FORM->checkbox('ftp',1,1).'</td>
							</tr>
							<tr>
								<td class="right">MySQL&nbsp;</td>
								<td>'.$X->FORM->checkbox('mysql',1,1).'</td>
							</tr>
							<tr>
								<td class="right">Pomiń&nbsp;<br />katalogi&nbsp;<br /><br /><b>/userfiles</b>&nbsp;</td>
								<td class="right">'.$X->FORM->textarea('skip_dirs',290,80).'</td>
							</tr>
							<tr>
								<td></td>
								<td colspan="2" class="right">
									<div class="fleft">'.$X->FORM->button_OC('Calc size','calc_size(true)').'</div>
									<div class="fright">'.$X->FORM->submit_link('Archiwizuj').'</div>
									<div class="clr"></div>
								</td>
							</tr>
						',
						'width' => 400
					)).'
					'.$X->FORM->hidden('action','backup').'
				</form>
			</div>

			<div class="fleft" style="margin-left:30px">
				<form action="" method="post">
					'.$X->ADMIN->inline_table(array(
						'head' => '<th class="center">Istniejące kopie</th><th class="center" width="95">FTP</th><th class="center" width="95">MySQL</th><th class="center" width="60">Usuń</th><th class="center" width="70">Przywróć</th>',
						'body' => $backups_rows,
						'width' => 500
					)).'
					'.$X->FORM->hidden('action','restore').'
				</form>
			</div>

			<div class="clr"></div>
			<br />
		';

		return $X->ADMIN->formbox($html);
	}


	function create_backup() {
		global $X;
		$X->STR->post_filter();

		$post_skip=explode("\n",trim($_POST['skip_dirs']));
		if(count($post_skip)>0 && !empty($post_skip[0])) {
			$exclude_sum=@array_merge($this->EXCLUDE, $post_skip);
			unset($this->EXCLUDE);
			foreach($exclude_sum as $x) $this->EXCLUDE[]=trim($x);
		}

		$data=date('Y-m-d_H.i.s');
		if(!is_dir(ROOT_PATH.'/backup/'.$data)) mkdir(ROOT_PATH.'/backup/'.$data, 0755, true);

		if($_POST['ftp']==1) $X->PACK->tar(ROOT_PATH.'/backup/'.$data.'/ftp.tar.gz', ROOT_PATH, $this->EXCLUDE);

		if($_POST['mysql']==1) {
			require_once(LIBS_PATH_ADMIN.'/_admin/mysql_dump.php');
			$dump_file = ROOT_PATH.'/backup/'.$data.'/sql.dump';
			$mysql_dump=$MYSQL_DUMP->_mysqldump($dump_file);
			if($mysql_dump==true) {
				$X->PACK->tar(ROOT_PATH.'/backup/'.$data.'/sql.tar.gz', $dump_file, false, ROOT_PATH.'/backup/'.$data);
				@unlink($dump_file);
			}
		}

		$X->URL->go();
	}


	function restore_backup() {
		global $X;

		if(count($_POST['del'])==0 && empty($_POST['restore'])) $X->URL->go();
		if(count($_POST['del'])>0) foreach($_POST['del'] as $dir) $X->UTIL->rmdir_rf(ROOT_PATH.'/backup/'.$dir);

		$del_exclude = array(ROOT_PATH.'/backup', ROOT_PATH.'/backup_temp');
		$base=ROOT_PATH.'/backup/'.$_POST['restore'];


		if(file_exists($base.'/sql.tar.gz')) {
			$X->PACK->untar($base.'/sql.tar.gz', $base);
			require_once(LIBS_PATH_ADMIN.'/_admin/mysql_dump.php');
			$sql_restore=$MYSQL_DUMP->_mysqlrestore($base.'/sql.dump');
			@unlink($base.'/sql.dump');
			$status_mysql=1;
		}


		if(file_exists($base.'/ftp.tar.gz')) {
			@mkdir(ROOT_PATH.'/backup_temp/', 0777);
			$extract = $X->PACK->untar($base.'/ftp.tar.gz', ROOT_PATH.'/backup_temp/');

			$root_d=opendir(ROOT_PATH);
			while(false!==($dir = readdir($root_d))) {
				if($dir!='.' && $dir!='..') {
					if(@in_array(ROOT_PATH.'/'.$dir, $del_exclude)) continue;
					if(empty($dir)) continue;
					$X->UTIL->rmdir_rf(ROOT_PATH.'/'.$dir);
				}
			}

			$dir=opendir(ROOT_PATH.'/backup_temp/');
			while(false!==($file = readdir($dir))) {
				if($file!='.' && $file!='..') rename(ROOT_PATH.'/backup_temp/'.$file, ROOT_PATH.'/'.$file);
			}
			$X->UTIL->rmdir_rf(ROOT_PATH.'/backup_temp/');
			$status_ftp=1;
		}


		if($status_mysql==1) $X->ADMIN->set_notif('ok','<b>Kopia bazy została przywrócona!</b>',3000);
		if($status_ftp==1) $X->ADMIN->set_notif('ok','<b>Kopia plików została przywrócona!</b>',3000);
		$X->URL->go();
	}


}
?>