var directionsDisplay;
var directionsService = new google.maps.DirectionsService();
var map;
var infowindow;
var myLocation = new google.maps.LatLng(49.827023, 19.054625);


$(window).resize(function () {
	waitForFinalEvent(function(){
		map.panTo(myLocation);
    }, 250, "gmap_center");
});


function map_initialize() {
	directionsDisplay = new google.maps.DirectionsRenderer();

	var myOptions = {
		zoom: 17,
		mapTypeId: google.maps.MapTypeId.ROADMAP,  //ROADMAP, SATELLITE, HYBRID, TERRAIN
		center: myLocation, //or any GPS
		panControl: true,
		zoomControl: true,
		scrollwheel: false,
		mapTypeControl: true,
		scaleControl: true,
		streetViewControl: true,
	};

	map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
	directionsDisplay.setMap(map);

	/*
	infowindow = new google.maps.InfoWindow({
		position: myLocation,
		content: '<div style="width:190px;"><b style="font-size:16px; color:#2B96CC">PERFECT DENT</b></div><div style="line-height:15px; padding:8px 0px 3px 0px;">43-300 Bielsko-Biała<br />ul. Legionów 27</div>'
	});
	infowindow.open(map);

	google.maps.event.addListener(marker,'click',function(){ infowindow.open(map); });
	google.maps.event.trigger(marker,'click');
	*/

	var marker = new google.maps.Marker({
		position: myLocation,
		map: map
	});
}


function map_calcRoute() {
	var start = document.getElementById("map_directions_start").value;
	var end = myLocation;
	var request = {
		origin:start,
		destination:end,
		travelMode: google.maps.DirectionsTravelMode.DRIVING  //DRIVING, WALKING, BICYCLING
	};
	directionsService.route(request, function(response, status) {
		if(status == google.maps.DirectionsStatus.OK) {
			directionsDisplay.setDirections(response);
			infowindow.close(map);
		}
	});
}