<?php
set_time_limit(1800);

	require_once('../config.php');
	require_once('../functions.php');

if(empty($_SESSION['backend']['user_id'])) exit;
	
	// Settings
	$save_path = DOCUMENTROOT ."/". rawurldecode($_POST["folderpath"]); //The path were we will save the file (getcwd() may not be reliable and should be tested in your environment)
	$upload_name = "Filedata";
	
	// Other variables	
	$MAX_FILENAME_LENGTH = 260;
	$file_name = "";
	$file_extension = "";
	$uploadErrors = array(
        0=>"There is no error, the file uploaded with success",
        1=>"The uploaded file exceeds the upload_max_filesize directive in php.ini",
        2=>"The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form",
        3=>"The uploaded file was only partially uploaded",
        4=>"No file was uploaded",
        6=>"Missing a temporary folder"
	);


//	$FILE['temp_path']=
//	$FILE['name']=''

	@mkdir(CACHE.'/file_manager/downloads/',0755,true);


	$FILE['name']=trim(@array_pop(explode('/',rawurldecode($_POST['url']))));
	if(empty($FILE['name'])) {
		HandleError("File has no name.");
		@unlink($FILE['temp_path']);
		exit(0);
	}


	// Validate file name (for our purposes we'll just remove invalid characters)
	$zzz=$FILE['name'];
	$ext=@array_pop(explode('.',$zzz));
	$new_filename=substr($zzz,0,-(strlen($ext)+1));
	$zzz = URL_mod($new_filename) . '.'.$ext;

	$FILE['temp_path']=CACHE.'/file_manager/downloads/'.$zzz;


	// Validate the upload
	if (!isset($FILE['name'])) {
		HandleError("File has no name.");
		@unlink($FILE['temp_path']);
		exit(0);
	}

	
	// Validate the file size (Warning: the largest files supported by this code is 2GB)
/* 
	$file_size = @filesize($FILE['temp_path']);
	if (!$file_size || $file_size > $max_file_size_in_bytes) {
		HandleError("File exceeds the maximum allowed size");
		@unlink($FILE['temp_path']);
		exit(0);
	}
	
	if ($file_size <= 0) {
		HandleError("File size outside allowed lower bound");
		@unlink($FILE['temp_path']);
		exit(0);
	}
*/



	$file_name = preg_replace('/[^'.$valid_chars_regex.']|\.+$/i', "", basename($zzz));
	if (strlen($file_name) == 0 || strlen($file_name) > $MAX_FILENAME_LENGTH) {
		HandleError("Invalid file name");
		@unlink($FILE['temp_path']);
		exit(0);
	}


	// Validate that we won't over-write an existing file

	if (file_exists($save_path . $zzz)) {
		HandleError("Taki plik już istnieje!");
		@unlink($FILE['temp_path']);
		exit(0);
	}


	// Validate file extension
	$path_info = pathinfo($zzz);
	$file_extension = $path_info["extension"];

	$is_valid_extension = false;
	$allowedExtensions = explode(',', $extension_whitelist);
	
	foreach ($allowedExtensions as $extension) {
		if (strcasecmp($file_extension, str_replace(' ', '', $extension)) == 0) {
			$is_valid_extension = true;
			break;
		}
	}
	
	if (!$is_valid_extension) {
		HandleError("Niedozwolone rozszerzenie!");
		@unlink($FILE['temp_path']);
		exit(0);
	}

	// Validate file contents (extension and mime-type can't be trusted)
	/*
		Validating the file contents is OS and web server configuration dependant.  Also, it may not be reliable.
		See the comments on this page: http://us2.php.net/fileinfo
		
		Also see http://72.14.253.104/search?q=cache:3YGZfcnKDrYJ:www.scanit.be/uploads/php-file-upload.pdf+php+file+command&hl=en&ct=clnk&cd=8&gl=us&client=firefox-a
		 which describes how a PHP script can be embedded within a GIF image file.
		
		Therefore, no sample code will be provided here.  Research the issue, decide how much security is
		 needed, and implement a solution that meets the needs.
	*/


	// Process the file
	/*
		At this point we are ready to process the valid file. This sample code shows how to save the file. Other tasks
		 could be done such as creating an entry in a database or generating a thumbnail.
		 
		Depending on your server OS and needs you may need to set the Security Permissions on the file after it has
		been saved.
	*/


	$dl_url=urldecode($_POST['url']);
	if(!stristr($dl_url,'http://') && !stristr($dl_url,'https://')) $dl_url='http://'.$dl_url;

	$handle=fopen(str_replace(' ','%20',stripslashes($dl_url)), "r");
	if($handle) {
		$zapis=@fopen($FILE['temp_path'],'a+');
		while(!@feof($handle)) {
			$packet=@fread($handle,32768);
			@fputs($zapis, $packet);
		}
		@fclose($handle);
      @fclose($zapis);
	}



	if (!rename($FILE["temp_path"], $save_path.$file_name)) {
		HandleError("Plik nie został zapisany!");
		@unlink($FILE['temp_path']);
		exit(0);
	} else {
		echo('Pobrano...');
	}

	exit(0);


/* Handles the error output. This error message will be sent to the uploadSuccess event handler.  The event handler
will have to check for any error messages and react as needed. */
function HandleError($message) {
	echo $message;
}
?>