<?
class exif
{
	function read_exif($filename) {
		$exif_data=@exif_read_data($filename);
		if(!$exif_data) return false;

		$f = explode('/', $exif_data['FNumber']);
		$time = explode(' ', $exif_data['DateTime']);
		$mm = explode('/', $exif_data['FocalLength']);

		switch($exif_data['ExposureProgram']) {
			case 0: $exp_mode = "Auto"; break;
			case 1: $exp_mode = "Program ręczny"; break;
			case 2: $exp_mode = "Priorytet czasu naświetlenia (Tv)"; break;
			case 3: $exp_mode = "Priorytet przysłony (Av)"; break;
			case 4: $exp_mode = "Ręcznie (M)"; break;
			case 5: $exp_mode = "Auto-DEP"; break;
		}

		return array(
			'model' 				=> $exif_data['Model'],
			'focal' 				=> $mm[0],
			'exposure' 			=> $exif_data['ExposureTime'],
			'aperture' 			=> round($f[0]/$f[1], 1),
			'iso' 				=> $exif_data['ISOSpeedRatings'],
			'exposure_mode' 	=> $exp_mode,
			'taken'				=> str_replace(':','-',$time[0]).' '.$time[1]
		);
/* 
		echo '<b>Model aparatu:</b> '.$exif_data['Model'].'<br />';
		echo '<b>Długość ogniskowej: </b>'.$mm[0].' mm<br />';
		echo '<b>Czas ekspozycji:</b> '.$exif_data['ExposureTime'].' s<br />';
		echo '<b>Wartość przysłony:</b> f / '.round($f[0]/$f[1], 1).'<br />';
		echo '<b>Wartość ISO:</b> '.$exif_data['ISOSpeedRatings'].'<br />';
		echo '<b>Tryb naświetlania: </b>'.$exp_mode.'<br />';
		echo '<b>Data wykonania zdjęcia:</b> '.str_replace(':','-',$time[0]).' '.$time[1].'<br />';
		echo '<br /><br /><br />';
*/
	}


	function del_exif($filename, $destination) {
		$handle = fopen($filename, "rb");
		$segment[] = fread($handle, 2);

		if($segment[0] === "\xFF\xD8") {
			$segment[] = fread($handle, 1);
			if($segment[1] === "\xFF") {
				rewind($handle);
				while(!feof($handle)) {
					$data = fread($handle, 2);
					if((preg_match("/FFE[1-9a-zA-Z]{1,1}/i", bin2hex($data))) || ($data === "\xFF\xFE")) {
						$position = ftell($handle);
						$size = fread($handle, 2);
						$newsize = 256 * ord($size{0}) + ord($size{1});
						$newpos = $position+$newsize;
						fseek($handle, $newpos);
					} else {
						$newfile[] = $data;
					}
				}
				fclose($handle);
				$newfile = implode('', $newfile);

				$handle = fopen($destination, "wb");
				fwrite($handle, $newfile);
				fclose($handle);
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

}
$EXIF=new exif();
?>