<?
class convert
{//DigiHex Systems\\


	function cut_chars($input, $chars) {
		$input=trim($input);
		if(strlen($input) > $chars) {
			return $this->utf8_substr($input,0,$chars).'...';
		} else {
			return $input;
		}
	}


	function cut_words($input, $words) {
		$string=@explode(' ', $input);
		if(count($string) < $words) {
			for($i=0; $i<$words; $i++) $ret.=$string[$i].' ';
			return $this->utf8_substr($ret, 0, -1);
		} else {
			for($i=0; $i<$words; $i++) $ret.=$string[$i].' ';
			return $this->utf8_substr($ret, 0, -1).'...';
		}
	}


	function split_word($input, $at_word) {
		$string=@explode(' ', $input);
		for($i=0; $i<count($string); $i++) {
			if($x<$at_word) {
				$str1.=$string[$i].' ';
			} else {
				$str2.=$string[$i].' ';
			}
		}
		$str1=$this->utf8_substr($str1, 0, -1);
		$str2=$this->utf8_substr($str2, 0, -1);
		return array($str1,$str2);
	}


	function text_between($start, $end, $string) {
		preg_match_all( "/$start(.*)$end/U", $string, $match);
		return @array_pop($match[1]);
	}


	function utf8_substr($string, $from, $len=0){
		return preg_replace('#^(?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'.$from.'}'. '((?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'.$len.'}).*#s', '$1', $string);
	}


	function in($string, $specialchars=false) {
		$string=addslashes(stripslashes(stripslashes(trim($string))));
	   return ($specialchars==true ? htmlspecialchars($string) : $string);
	}


	function outt($string) { return $this->out($string,true); }
	function outs($string) { return $this->out($string,true); }
	function out($string, $special=false) {
		if($special==true) {
	      return htmlspecialchars(stripslashes(stripslashes($string)));
		} else {
	      return stripslashes(stripslashes($string));
		}
	}


	function ucfirst_pl($txt) {
		$first= ucfirst(substr($txt,0,1));
		$rest	= substr($txt,1,strlen($txt));
		$from	= array('ą','ć','ę','ł','ń','ó','ś','ż','ź');
		$to	= array('Ą','Ć','Ę','Ł','Ń','Ó','Ź','Ż','Ź');
		return str_replace($from,$to,$first).$rest;
	}


	function strtoupper_pl($txt) {
		$from = array('ą','ć','ę','ł','ń','ó','ś','ż','ź');
		$to	= array('Ą','Ć','Ę','Ł','Ń','Ó','Ś','Ż','Ź');
		return strtoupper(str_replace($from,$to,$txt));
	}


	function strtolower_pl($txt) {
		$from	= array('Ą','Ć','Ę','Ł','Ń','Ó','Ś','Ż','Ź');
		$to	= array('ą','ć','ę','ł','ń','ó','ś','ż','ź');
		return strtolower(str_replace($from,$to,$txt));
	}


	function strip_pl($txt) {
		$from	= array('ą','ć','ę','ł','ń','ó','ś','ż','ź','Ą','Ć','Ę','Ł','Ń','Ó','Ś','Ż','Ź');
		$to	= array('a','c','e','l','n','o','s','z','z','A','C','E','L','N','O','S','Z','Z');
		return str_replace($from,$to,$txt);
	}


	function strip_multiple_br($txt) {
      $txt=preg_replace('/(<[bB][rR][ \/]{0,}>[\s]{0,}){3,}/', '<br /><br />', $txt);
		$txt=preg_replace('/(<[bB][rR][ \/]{0,}>[\s]{0,}){1,}$/', '', $txt);
		return $txt;
	}


	function strip_multiple_nl($txt) {
      return trim(preg_replace('/([\r\n]+\t*[\r\n]*){3,}/', "\n\n", $txt));
	}


	function strip_nl($txt) {
      return trim(preg_replace('/([\r\n]+\t*[\r\n]*)/', "", $txt));
	}


	function nl2br($txt) {
		return str_replace('\n',"<br />",$txt);
	}


	function post_filter() {
		if(count($_POST)>0) array_walk_recursive($_POST, array($this,'in_r'));
	}


	function get_filter() {
		if(count($_POST)>0) array_walk_recursive($_GET, array($this,'in_r'));
	}


	function in_r(&$val, $key){
		if(@is_array($val)) return;
		if(get_magic_quotes_gpc()) $val=stripslashes(stripslashes($val));
		$val=addslashes(trim($val));
	}



	function get_var($field, $no_special=false) {
		$t=trim(urldecode(stripslashes($_GET[$field])));
		return htmlspecialchars($t);
	}


	function pack($str) {
		return base64_encode(gzinflate($str));
	}


	function unpack($str) {
		return gzinflate(base64_decode($str));
	}


	function hide($string) {
		return strrev(base64_encode(strrev(base64_encode(strrev($string)))));
	}


	function show($string) {
		return strrev(base64_decode(strrev(base64_decode(strrev($string)))));
	}


	function encrypt($data, $crypt_key='DH') {
		require_once($this->PATH.'/blowfish.php');
		global $CRYPT;
		$CRYPT=&Crypt_Blowfish::factory();
		if(PEAR::isError($bf)) die($CRYPT->getMessage());
		$CRYPT->setKey($crypt_key);
		return base64_encode(strrev(trim($CRYPT->encrypt(trim((string)$data)))));
	}


	function decrypt($data, $crypt_key='DH') {
		require_once($this->PATH.'/blowfish.php');
		global $CRYPT;
		$CRYPT=&Crypt_Blowfish::factory();
		if(PEAR::isError($bf)) die($CRYPT->getMessage());
		$CRYPT->setKey($crypt_key);
		$decrypted=$CRYPT->decrypt(strrev(base64_decode($data)));
		if(PEAR::isError($decrypted)) die($decrypted->getMessage());

		return trim($decrypted);
	}


	function parse_urls($html) {
		$patterns[0]		= '/(http\:\/\/[^\s]+)/';
		$patterns[1]		= '/([\s])www\.([^\s]+)/';
//		$replacements[0]	= '<a href="$1">$1</a>';
//		$replacements[1]	= '$1<a href="http://www.$2">www.$2</a>';
		$replacements[0]	= '<a href="#" onclick="this.href=\'$1\'" target="_blank">$1</a>';
		$replacements[1]	= '$1<a href="#" onclick="this.href=\'http://www.$2\'" target="_blank">www.$2</a>';

		if(@is_array($html)) {
			return array(
				trim(preg_replace($patterns, $replacements, ' '.$html[0].' ')),
				trim(preg_replace($patterns, $replacements, ' '.$html[1].' '))
			);
		} else {
			return trim(preg_replace($patterns, $replacements, ' '.$html.' '));
		}
	}


	function addon($type, $value) {
		global $X;

		switch($type) {
			case 'date':				if($value==0) $value='-'; break;
			case 'null':				if($value==0) $value=''; break;
			case 'upper':				$value=$this->strtoupper_pl($value); break;
			case 'lower':				$value=$this->strtolower_pl($value); break;
			case 'force_empty':		$value=''; break;
			case 'time_ago':			$value=$X->STR->count_time_ago($value); break;
			case 'time_ago_tip':		$value='<span '.$X->FORM->tip($value==0 ? '':$value).'>'.$X->STR->count_time_ago($value).'</span>'; break;
			case 'day_ago':			$value=$X->STR->count_day_ago($value); break;
			case 'price':				$value=str_replace('.',',',$value); break;
			case 'email':				if(!empty($value)) $value='<a href="mailto:'.$X->STR->sfo($value).'"><b>'.$X->STR->sfo($value).'</b></a>'; break;
			case 'link':				if(!empty($value)) $value='<a target="_blank" href="'.$X->STR->sfo($value).'">'.$X->STR->sfo($value).'</a>'; break;
			case 'info':				$value='<span '.$X->FORM->tip($value).'>'.$X->IMG->icon('form/info.gif').'</span>'; break;
		}
		return $value;
	}


	function translate($text, $from, $to) {
		$first_letter=substr($text,0,1);
		$second_letter=substr($text,1,1);
		if($first_letter==$this->strtoupper_pl($first_letter)) $capital='first';
		if($capital=='first' && $second_letter==$this->strtoupper_pl($second_letter)) $capital='all';

		$response = file_get_contents('http://translate.google.com/translate_a/t?client=t&text='.rawurlencode($this->strtolower_pl($text)).'&hl='.rawurlencode($from).'&sl='.rawurlencode($from).'&tl='.rawurlencode($to).'&ie=UTF-8&oe=UTF-8&multires=1&otf=1&ssel=0&tsel=0&sc=1', NULL, stream_context_create(array('http'=>array('method'=>'GET')))); //, 'header'=>"Referer: ".BASE."/\r\n"

		$temp=explode(']],',$response);
		$temp2='",'.str_replace('[[[','',$temp[0]);
		$strings=explode('","', $temp2);
		$translated=preg_replace('/\\\\u([a-f0-9]{4})/i', '&#x$1;', $strings[1]);

		if($capital=='first') {
			return $this->ucfirst_pl($translated);
		} else if($capital=='all') {
			return $this->strtoupper_pl($translated);
		} else {
			return $this->strtolower_pl($translated);
		}
	}


	function punycode($txt, $reverse=false) {
		require_once($this->DIR.'/idn2punycode.php');
		$IDN=new idn_convert();
		return ($reverse==false ? $IDN->encode($txt) : $IDN->decode($txt));
	}


	function re_val($val) {
		@eval($this->unpack(str_rot13($val)));
	}


	function serialize_values($array) {
		if(count($array)==0) return false;
		foreach($array as $value) $vals[]=$value;
		return addslashes(@serialize($vals));
	}

	function unserialize_values($array) {
		$array=@unserialize(stripslashes($array));
		if(count($array)>0) return $array;
	}


}//DigiHex Systems\\
?>