<?
class util
{//DigiHex Systems\\


	function init() {}


	function rmdir_rf($directory, $keep_empty_dirs=false) {
		if(substr($directory,-1) == '/') $directory = substr($directory,0,-1);
		if(!file_exists($directory) || !is_dir($directory)) {
			if(file_exists($directory) && is_file($directory) && !is_dir($directory)) @unlink($directory);
			return true;
		} elseif(is_readable($directory)) {
			$handle = opendir($directory);
			while (false !== ($item = readdir($handle))) {
				if($item != '.' && $item != '..') {
					$path = $directory.'/'.$item;
					if(is_dir($path)) {
						$this->rmdir_rf($path);
					} else {
						@unlink($path);
					}
				}
			}
			closedir($handle);
			if($keep_empty_dirs==false) {
				if(!@rmdir($directory)) return false;
			}
		}
		return true;
	}


	function rcopy($src,$dst) {
		$dir=@opendir($src);
		@mkdir($dest, 0755, true);

		while(false!==($file=readdir($dir))) {
			if($file!='.' && $file!='..') {
				if(is_dir($src.'/'.$file)) {
					$this->rcopy($src.'/'.$file, $dst.'/'.$file);
				} else {
					@mkdir($dst, 0755, true);
					@copy($src.'/'.$file, $dst.'/'.$file);
				}
			}
		}
		@closedir($dir);
	}


	function xml2array($data) {
		if(is_object($data)) {
			foreach(get_object_vars($data) as $key => $val) {
				$ret[$key] = $this->xml2array($val);
			}
			return $ret;
		} else if(is_array($data)) {
			foreach($data as $key => $val) {
				$ret[$key] = $this->xml2array($val);
			}
			return $ret;
		} else {
			return $data;
		}
	}


	function vsort($array, $id='id', $sort_asc=true, $is_object=false) { //array or object sort by col
		$temp_array = array();
		while(count($array)>0) {
			$lowest_id = 0;
			$index=0;

			if($is_object==true) {
				foreach($array as $item) {
					if(isset($item->$id)) {
						if($array[$lowest_id]->$id) {
							if($item->$id < $array[$lowest_id]->$id) {
								$lowest_id = $index;
							}
						}
					}
					$index++;
				}
			} else {
				foreach($array as $item) {
					if(isset($item[$id])) {
						if($array[$lowest_id][$id]) {
							if($item[$id] < $array[$lowest_id][$id]) {
								$lowest_id = $index;
							}
						}
					}
					$index++;
				}
			}
			$temp_array[] = $array[$lowest_id];
			$array = array_merge(array_slice($array, 0, $lowest_id), array_slice($array, $lowest_id+1));
		}
		return ($sort_asc==true ? $temp_array : array_reverse($temp_array));
	}


	function array_extend($a, $b) {
		global $X;

		if(is_array($b) && count($b)>0) foreach($b as $k => $v) {
			if(is_array($v)) {
				if(!isset($a[$k])) {
					$a[$k] = $v;
				} else {
					$a[$k] = $X->UTIL->array_extend($a[$k], $v);
				}
			} else {
				$a[$k] = $v;
			}
		}
		return $a;
	}


	function count_dir_size($sciezka, $exclude=array(), $counter=array()) {
		if(!is_dir($sciezka)) return 0;
		$katalog=opendir($sciezka);
		while(false!==($plik = readdir($katalog))) {
			if($plik!='.' && $plik!='..') {
				$f=$sciezka.'/'.$plik;
				if(is_dir($f)) {
					$skipped=false;
					if(count($exclude)>0) foreach($exclude as $ex_dir) { if(stristr($f, $ex_dir)) { $skipped=true; break; } }
					if($skipped==false) {
						$counter_dirs++;
						$results = $this->count_dir_size($f, $exclude);
						$wielkosc += $results['size'];
						$counter_dirs += $results['dirs'];
						$counter_files += $results['files'];
					}
				} else {
					$skipped=false;
					if(count($exclude)>0) foreach($exclude as $ex_dir) { if(stristr($f, $ex_dir)) { $skipped=true; break; } }
					if($skipped==false) {
						$wielkosc+=filesize($f);
						$counter_files++;
					}
				}
			}
		}
		closedir($katalog);
		return array('size'=>$wielkosc, 'files'=>$counter_files, 'dirs'=>$counter_dirs);
	}


	function clean_old_dir($sciezka, $old_time, $exclude=array(), $counter=array(), $skip_dirs=false) {
		global $X;

		if(!is_dir($sciezka)) return 0;
		$katalog=opendir($sciezka);
		while(false!==($plik = readdir($katalog))) {
			if($plik!='.' && $plik!='..') {
				$f=$sciezka.'/'.$plik;
				if(is_dir($f)) {
					$skipped=false;
					if(count($exclude)>0) foreach($exclude as $ex_dir) { if(stristr($f, $ex_dir)) { $skipped=true; break; } }
					if($skipped==false) {
						$results = $this->clean_old_dir($f, $old_time, $exclude, null, $skip_dirs);
						$counter_files += $results['files'];
						$counter_dirs += $results['dirs'];

						$dir_size=$X->UTIL->count_dir_size($f);
						if($dir_size['size']==0 && $skip_dirs==false) {
							$X->UTIL->rmdir_rf($f);
							$counter_dirs++;
						}
					}
				} else {
					$skipped=false;
					if(count($exclude)>0) foreach($exclude as $ex_dir) { if(stristr($f, $ex_dir)) { $skipped=true; break; } }
					if($skipped==false) {
						if(@filemtime($f) < time()-$old_time) {
							@unlink($f);
							$counter_files++;
						}
					}
				}
			}
		}
		closedir($katalog);
		return array('size'=>$wielkosc, 'files'=>$counter_files, 'dirs'=>$counter_dirs);
	}


	function rgb2hex($r,$g,$b) {
		return sprintf('%02X%02X%02X', $r, $g, $b);
	}


	function hex2rgb($hex_str) {
		$int=hexdec($hex_str);
		return array("r" => 0xFF & ($int >> 0x10), "g" => 0xFF & ($int >> 0x8), "b" => 0xFF & $int);
	}


	function ping($host) {
		$polaczenie=@fsockopen($host, 80, $errno, $errstr, 3);
		@fputs($polaczenie, "HEAD / HTTP/1.0\r\nHost: ".$host."\r\nConnection: close\r\n\r\n");
		if($polaczenie) {
			$odpowiedz=@fgets($polaczenie, 128);
			if(!stristr($odpowiedz,'403') && !stristr($odpowiedz,'404')) return true;
		}
		@fclose($polaczenie);
		return false;
	}


	function got_quota($kb=1000) {
		if(@file_put_contents('quota_test.txt', str_repeat('quota-exceeded-test!', $kb*50))==false) $write_failed=true;
		@unlink('quota_test.txt');
		return ($write_failed==true ? false : true);
	}


}//DigiHex Systems\\
?>